<?php
header("Content-Type: application/json; charset=UTF-8");

$file = __DIR__ . "/lesson19.json";
$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    echo json_encode(["success"=>false, "message"=>"Invalid JSON"]);
    exit;
}

$title = trim($input["lesson_title"] ?? "");
$des   = trim($input["lesson_descrip"] ?? "");

if ($title === "" || $des === "") {
    echo json_encode(["success"=>false, "message"=>"Empty fields"]);
    exit;
}

$data = [];
if (file_exists($file)) {
    $data = json_decode(file_get_contents($file), true);
    if (!is_array($data)) $data = [];
}

$newId = count($data) > 0 ? (max(array_column($data, "id")) + 1) : 1;

$data[] = [
    "id" => $newId,
    "lesson_title" => $title,
    "lesson_descrip" => $des
];

file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

echo json_encode(["success"=>true, "message"=>"Word Added", "id"=>$newId]);
