<?php
header("Content-Type: application/json; charset=UTF-8");

$file = __DIR__ . "/lesson20.json";
$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    echo json_encode(["success"=>false, "message"=>"Invalid JSON"]);
    exit;
}

$id    = intval($input["id"] ?? 0);
$title = trim($input["lesson_title"] ?? "");
$des   = trim($input["lesson_descrip"] ?? "");

if ($id <= 0 || $title === "" || $des === "") {
    echo json_encode(["success"=>false, "message"=>"Invalid data"]);
    exit;
}

$data = [];
if (file_exists($file)) {
    $data = json_decode(file_get_contents($file), true);
    if (!is_array($data)) $data = [];
}

$found = false;
foreach ($data as &$row) {
    if (intval($row["id"]) === $id) {
        $row["lesson_title"]  = $title;
        $row["lesson_descrip"] = $des;
        $found = true;
        break;
    }
}

if ($found) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(["success"=>true, "message"=>"Updated"]);
} else {
    echo json_encode(["success"=>false, "message"=>"ID not found"]);
}
