<?php
header("Content-Type: application/json; charset=UTF-8");

$file = __DIR__ . "/lesson36.json";
$input = json_decode(file_get_contents("php://input"), true);

if (!$input) {
    echo json_encode(["success"=>false, "message"=>"Invalid JSON"]);
    exit;
}

$id = intval($input["id"] ?? 0);

if ($id <= 0) {
    echo json_encode(["success"=>false, "message"=>"Invalid ID"]);
    exit;
}

$data = [];
if (file_exists($file)) {
    $data = json_decode(file_get_contents($file), true);
    if (!is_array($data)) $data = [];
}

$newData = array_values(array_filter($data, function ($row) use ($id) {
    return intval($row["id"]) !== $id;
}));

if (count($newData) === count($data)) {
    echo json_encode(["success"=>false, "message"=>"ID not found"]);
    exit;
}

file_put_contents($file, json_encode($newData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

echo json_encode(["success"=>true, "message"=>"Deleted"]);
