<?php
header('Content-Type: application/json; charset=utf-8');
// Read raw JSON body
$raw = file_get_contents("php://input");
if (!$raw) { echo json_encode(["ok"=>0,"msg"=>"no input"]); exit; }

$in = json_decode($raw, true);
$user = preg_replace('/[^a-zA-Z0-9_\-]/','', $in['user_id'] ?? '');
$contacts = $in['contacts'] ?? [];

if (!$user || !is_array($contacts)) {
  echo json_encode(["ok"=>0,"msg"=>"bad input"]); exit;
}

$storeDir = __DIR__ . "/data";
if (!is_dir($storeDir)) { @mkdir($storeDir, 0755, true); }

$file = $storeDir . "/" . $user . ".json";

// Overwrite with latest upload (small/simple).
// If you prefer merge+dedupe, implement here.
file_put_contents($file, json_encode($contacts, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT));

echo json_encode(["ok"=>1, "count"=>count($contacts)]);
