<?php
header('Content-Type: application/json; charset=utf-8');

$user = preg_replace('/[^a-zA-Z0-9_\-]/','', $_GET['user_id'] ?? '');
$q = strtolower($_GET['q'] ?? '');

$file = __DIR__ . "/data/" . $user . ".json";
if (!$user || !file_exists($file)) { echo "[]"; exit; }

$list = json_decode(file_get_contents($file), true) ?: [];
$res = [];

foreach ($list as $c) {
  $name = strtolower($c['name'] ?? '');
  $phone = $c['phone'] ?? '';
  if ($q === '' || strpos($name, $q) !== false || strpos($phone, $q) !== false) {
    $res[] = $c;
  }
}

echo json_encode($res, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
