<?php
include "config.php";
header("Content-Type: application/json; charset=utf-8");

$action = $_POST['action'] ?? '';
$name = trim($_POST['name'] ?? '');
$newname = trim($_POST['newname'] ?? '');
$data = load_json();

if ($action == 'add') {
    foreach ($data as $c) {
        if (strtolower($c['category']) == strtolower($name)) {
            echo json_encode(["status" => "error", "msg" => "Category already exists"]);
            exit;
        }
    }
    $data[] = ["category" => $name, "quotes" => []];
    save_json($data);
    echo json_encode(["status" => "ok", "msg" => "Category added"]);

} elseif ($action == 'update') {
    $found = false;
    foreach ($data as &$c) {
        if (strtolower($c['category']) == strtolower($name)) {
            $c['category'] = $newname;
            $found = true;
            break;
        }
    }
    if ($found) {
        save_json($data);
        echo json_encode(["status" => "ok", "msg" => "Category updated"]);
    } else {
        echo json_encode(["status" => "error", "msg" => "Category not found"]);
    }

} elseif ($action == 'delete') {
    $found = false;
    foreach ($data as $i => $c) {
        if (strtolower($c['category']) == strtolower($name)) {
            unset($data[$i]);
            $data = array_values($data);
            $found = true;
            break;
        }
    }
    if ($found) {
        save_json($data);
        echo json_encode(["status" => "ok", "msg" => "Category deleted"]);
    } else {
        echo json_encode(["status" => "error", "msg" => "Category not found"]);
    }

} else {
    echo json_encode(["status" => "error", "msg" => "Invalid action"]);
}
?>