<?php
include "config.php";
header("Content-Type: application/json; charset=utf-8");

$action = $_POST['action'] ?? '';
$category = trim($_POST['category'] ?? '');
$old = trim($_POST['old'] ?? '');
$new = trim($_POST['new'] ?? '');

$data = load_json();
$found = false;

foreach ($data as &$c) {
    if (strtolower($c['category']) == strtolower($category)) {
        if ($action == 'add') {
            $c['quotes'][] = $new;
            $found = true;
        } elseif ($action == 'update') {
            $index = array_search($old, $c['quotes']);
            if ($index !== false) {
                $c['quotes'][$index] = $new;
                $found = true;
            }
        } elseif ($action == 'delete') {
            $index = array_search($old, $c['quotes']);
            if ($index !== false) {
                unset($c['quotes'][$index]);
                $c['quotes'] = array_values($c['quotes']);
                $found = true;
            }
        }
        break;
    }
}

if ($found) {
    save_json($data);
    echo json_encode(["status" => "ok", "msg" => "Quote $action successful"]);
} else {
    echo json_encode(["status" => "error", "msg" => "Category or quote not found"]);
}
?>