<?php
header("Content-Type: application/json; charset=UTF-8");

$file = __DIR__ . "/server_version.json";

// Function to increase version automatically (1.0.0 → 1.0.1)
function bumpVersion($v){
    $parts = explode('.', $v);
    if(count($parts) < 3) $parts = [1,0,0];
    $parts[2] = (int)$parts[2] + 1;
    return implode('.', $parts);
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $base_url = isset($_POST['base_url']) ? trim($_POST['base_url']) : '';

    if ($base_url !== '') {
        // পুরনো JSON থেকে version পড়ো
        $old = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
        $old_version = isset($old['version']) ? $old['version'] : "1.0.0";

        // version +1 করো
        $new_version = bumpVersion($old_version);

        // নতুন ডেটা লিখে দাও
        $data = array(
            "version" => $new_version,
            "base_url" => $base_url
        );
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

        echo json_encode(array("status" => "success", "message" => "Server version updated", "data" => $data));
    } else {
        echo json_encode(array("status" => "error", "message" => "Missing base_url"));
    }
} else {
    // GET → বর্তমান JSON রিটার্ন করো
    if (file_exists($file)) {
        readfile($file);
    } else {
        echo json_encode(array(
            "version" => "1.0.0",
            "base_url" => "https://kclcbd.com/sell/premium/"
        ));
    }
}
?>