<?php
header("Content-Type: application/json; charset=UTF-8");
$file = __DIR__ . "/server_version.json";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $version = isset($_POST['version']) ? trim($_POST['version']) : '';
    $base_url = isset($_POST['base_url']) ? trim($_POST['base_url']) : '';

    if ($version !== '' && $base_url !== '') {
        $data = array(
            "version" => $version,
            "base_url" => $base_url
        );
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        echo json_encode(array("status" => "success", "message" => "Server version updated"));
    } else {
        echo json_encode(array("status" => "error", "message" => "Missing version or base_url"));
    }
} else {
    if (file_exists($file)) {
        readfile($file);
    } else {
        echo json_encode(array("version" => "1.0.0", "base_url" => "https://kclcbd.com/sell/premium/"));
    }
}
?>
