<?php
require_once __DIR__ . "/config.php";
require_api_key();

$category = isset($_POST["category"]) ? trim($_POST["category"]) : "";
$index = isset($_POST["index"]) ? $_POST["index"] : null;
$text = isset($_POST["text"]) ? trim($_POST["text"]) : "";

if($category === ""){
    json_response(["success"=>false, "message"=>"Missing category"], 400);
}
$d = ensure_data_shape();

// pick list
$list = null;
if(is_array($d["quotes_map"]) && isset($d["quotes_map"][$category])){
    $list = &$d["quotes_map"][$category];
} else if(is_object($d["quotes_map"]) && isset($d["quotes_map"]->$category)){
    $list = &$d["quotes_map"]->$category;
} else {
    json_response(["success"=>false, "message"=>"Category not found"], 404);
}

if($index !== null && $index !== ""){
    $i = intval($index);
    if($i < 0 || $i >= count($list)){
        json_response(["success"=>false, "message"=>"Index out of range"], 400);
    }
    array_splice($list, $i, 1);
} else if($text !== ""){
    $pos = array_search($text, $list, true);
    if($pos === false){
        json_response(["success"=>false, "message"=>"Text not found"], 404);
    }
    array_splice($list, $pos, 1);
} else {
    json_response(["success"=>false, "message"=>"Provide index or text to delete"], 400);
}

if(!write_json(QUOTES_FILE, $d)){
    json_response(["success"=>false, "message"=>"Failed to save"], 500);
}
json_response(["success"=>true]);
?>
