<?php
require_once __DIR__ . "/config.php";
$d = ensure_data_shape();
$base = read_json(SERVER_VERSION_FILE);
$base_url = isset($base["base_url"]) ? rtrim($base["base_url"], "/") : "";
// Attach absolute image URLs
$cats = [];
foreach($d["categories"] as $c){
    $img = isset($c["image"]) ? $c["image"] : "";
    if($img !== "" && strpos($img, "http") !== 0){
        // make relative to base_url
        $rel = preg_replace('#^' . preg_quote(__DIR__, '#') . '#', '', $img);
        $rel = ltrim($rel, "/");
        $img = ($base_url !== "" ? $base_url . "/" : "") . $rel;
    }
    $cats[] = ["name"=>$c["name"], "image"=>$img];
}
json_response(["categories"=>$cats]);
?>
