<?php
require_once __DIR__ . "/config.php";
require_api_key();

$base = read_json(SERVER_VERSION_FILE);
if(!$base) $base = ["version"=>"1.0.0", "base_url"=>""];

// accept base_url change
if(isset($_POST["base_url"])){
    $base_url = trim($_POST["base_url"]);
    // normalize trailing slash
    if($base_url !== ""){
        $base_url = rtrim($base_url, "/");
    }
    $base["base_url"] = $base_url;
}

// bump patch version
function bumpVersion($v){
    $parts = explode('.', $v);
    if(count($parts) < 3) $parts = [1,0,0];
    $parts = array_map("intval", $parts);
    $parts[2]++;
    return $parts[0].".".$parts[1].".".$parts[2];
}

$base["version"] = bumpVersion(isset($base["version"]) ? $base["version"] : "1.0.0");

if(!write_json(SERVER_VERSION_FILE, $base)){
    json_response(["success"=>false, "message"=>"Failed to write server_version.json"], 500);
}

json_response(["success"=>true, "server"=>$base]);
?>
