<?php
require_once __DIR__ . "/config.php";
require_api_key();

$name = isset($_POST["name"]) ? trim($_POST["name"]) : "";
if($name === ""){
    json_response(["success"=>false, "message"=>"Missing category name"], 400);
}
$d = ensure_data_shape();
// check exists
foreach($d["categories"] as $c){
    if(strcasecmp($c["name"], $name) === 0){
        json_response(["success"=>false, "message"=>"Category already exists"], 409);
    }
}
$img_path = "";
if(isset($_FILES["image"])){
    list($ok, $res) = save_image_upload("image", UPLOAD_DIR_CATEGORIES);
    if(!$ok) json_response(["success"=>false, "message"=>$res], 400);
    $img_path = $res;
}
$d["categories"][] = ["name"=>$name, "image"=>$img_path];
if(is_array($d["quotes_map"])){
    $d["quotes_map"][$name] = [];
} else {
    $d["quotes_map"]->$name = [];
}
if(!write_json(QUOTES_FILE, $d)){
    json_response(["success"=>false, "message"=>"Failed to save"], 500);
}

$base = read_json(SERVER_VERSION_FILE);
$base_url = isset($base["base_url"]) ? rtrim($base["base_url"], "/") : "";
$img_url = $img_path;
if($img_url !== "" && strpos($img_url, "http") !== 0){
    $rel = preg_replace('#^' . preg_quote(__DIR__, '#') . '#', '', $img_url);
    $rel = ltrim($rel, "/");
    $img_url = ($base_url !== "" ? $base_url . "/" : "") . $rel;
}

json_response(["success"=>true, "message"=>"Category added", "image_url"=>$img_url]);
?>
