<?php
// NLIND Server v5 - JSON CRUD Ready

// ====== Basic Config ======
define("API_KEY", "soma_2025_secure");  // change this if you want
define("DATA_DIR", __DIR__);
define("QUOTES_FILE", DATA_DIR . "/quotes.json");
define("SERVER_VERSION_FILE", DATA_DIR . "/server_version.json");
define("UPLOAD_DIR_CATEGORIES", DATA_DIR . "/uploads/categories");

// Allowed MIME (basic)
$ALLOWED_IMAGE_MIME = ["image/jpeg", "image/png", "image/webp"];

// ====== Helpers ======
function json_response($arr, $code = 200){
    http_response_code($code);
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($arr, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}
function read_json($file){
    if(!file_exists($file)) return null;
    $txt = @file_get_contents($file);
    if($txt === false) return null;
    $data = json_decode($txt, true);
    return $data;
}
function write_json($file, $data){
    $tmp = $file . ".tmp";
    $fp = @fopen($tmp, "wb");
    if(!$fp) return false;
    @flock($fp, LOCK_EX);
    $ok = @fwrite($fp, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)) !== false;
    @flock($fp, LOCK_UN);
    @fclose($fp);
    if($ok){
        return @rename($tmp, $file);
    } else {
        @unlink($tmp);
        return false;
    }
}

// ====== Data Init/Migration ======
function ensure_data_shape(){
    $d = read_json(QUOTES_FILE);
    if($d === null){
        $d = ["categories"=>[], "quotes_map"=>new stdClass()];
        write_json(QUOTES_FILE, $d);
        return $d;
    }
    // migrate if legacy format: list of {"category": "...", "quotes":[...]}
    if(isset($d[0]) && is_array($d[0]) && isset($d[0]["category"])){
        $quotes_map = [];
        $categories = [];
        foreach($d as $entry){
            $cat = $entry["category"];
            $quotes_map[$cat] = isset($entry["quotes"]) ? $entry["quotes"] : [];
            // no image info in legacy; leave blank
            $categories[] = ["name"=>$cat, "image"=>""];
        }
        $d = ["categories"=>$categories, "quotes_map"=>$quotes_map];
        write_json(QUOTES_FILE, $d);
    }
    // if quotes_map missing but categories present
    if(!isset($d["quotes_map"]) && isset($d["categories"])){
        $d["quotes_map"] = new stdClass();
        foreach($d["categories"] as $c){
            $name = is_array($c) && isset($c["name"]) ? $c["name"] : (string)$c;
            $d["quotes_map"]->$name = [];
        }
        write_json(QUOTES_FILE, $d);
    }
    // if categories missing but quotes_map present
    if(!isset($d["categories"]) && isset($d["quotes_map"])){
        $cats = [];
        foreach($d["quotes_map"] as $k=>$v){
            $cats[] = ["name"=>$k, "image"=>""];
        }
        $d["categories"] = $cats;
        write_json(QUOTES_FILE, $d);
    }
    return $d;
}

function save_image_upload($field, $target_dir){
    global $ALLOWED_IMAGE_MIME;
    if(!isset($_FILES[$field]) || $_FILES[$field]["error"] !== UPLOAD_ERR_OK){
        return [false, "No file uploaded or upload error."];
    }
    $tmp = $_FILES[$field]["tmp_name"];
    $mime = mime_content_type($tmp);
    if(!in_array($mime, $ALLOWED_IMAGE_MIME)){
        return [false, "Unsupported image type."];
    }
    if(!is_dir($target_dir)){
        @mkdir($target_dir, 0755, true);
    }
    $ext = pathinfo($_FILES[$field]["name"], PATHINFO_EXTENSION);
    $basename = preg_replace('/[^a-zA-Z0-9_\-]/','_', pathinfo($_FILES[$field]["name"], PATHINFO_FILENAME));
    if($basename === "") $basename = "cat_" . time();
    $filename = $basename . "_" . substr(sha1(uniqid("", true)),0,6) . "." . strtolower($ext);
    $dest = rtrim($target_dir, "/") . "/" . $filename;
    if(!move_uploaded_file($tmp, $dest)){
        return [false, "Failed to move upload."];
    }
    return [true, $dest];
}

function require_api_key(){
    $key = isset($_POST["api_key"]) ? $_POST["api_key"] : (isset($_GET["api_key"]) ? $_GET["api_key"] : "");
    if($key !== API_KEY){
        json_response(["success"=>false, "message"=>"Unauthorized"], 401);
    }
}
?>
