<?php
require_once __DIR__ . "/config.php";
require_api_key();

$category = isset($_POST["category"]) ? trim($_POST["category"]) : "";
$text = isset($_POST["text"]) ? trim($_POST["text"]) : "";
if($category === "" || $text === ""){
    json_response(["success"=>false, "message"=>"Missing category or text"], 400);
}
$d = ensure_data_shape();

// ensure category exists
$exists = false;
foreach($d["categories"] as $c){
    if(strcasecmp($c["name"], $category) === 0){ $exists = true; break; }
}
if(!$exists) json_response(["success"=>false, "message"=>"Category not found"], 404);

// add quote
if(is_array($d["quotes_map"])){
    if(!isset($d["quotes_map"][$category])) $d["quotes_map"][$category] = [];
    $d["quotes_map"][$category][] = $text;
} else {
    if(!isset($d["quotes_map"]->$category)) $d["quotes_map"]->$category = [];
    $tmp = $d["quotes_map"]->$category;
    $tmp[] = $text;
    $d["quotes_map"]->$category = $tmp;
}

if(!write_json(QUOTES_FILE, $d)){
    json_response(["success"=>false, "message"=>"Failed to save"], 500);
}
json_response(["success"=>true, "message"=>"Quote added"]);
?>
