<?php
require_once __DIR__ . "/config.php";
require_api_key();

$name = isset($_POST["name"]) ? trim($_POST["name"]) : "";
$delete_image = isset($_POST["delete_image"]) ? (bool)$_POST["delete_image"] : false;
if($name === ""){
    json_response(["success"=>false, "message"=>"Missing category name"], 400);
}

$d = ensure_data_shape();
// remove from categories
$found = false;
$newCats = [];
$img_to_del = "";
foreach($d["categories"] as $c){
    if(strcasecmp($c["name"], $name) === 0){
        $found = true;
        if($delete_image && isset($c["image"]) && $c["image"] !== "" && file_exists($c["image"])){
            $img_to_del = $c["image"];
        }
        continue;
    }
    $newCats[] = $c;
}
if(!$found) json_response(["success"=>false, "message"=>"Category not found"], 404);
$d["categories"] = $newCats;
// remove quotes
if(is_array($d["quotes_map"])){
    unset($d["quotes_map"][$name]);
} else if(is_object($d["quotes_map"])){
    unset($d["quotes_map"]->$name);
}
if(!write_json(QUOTES_FILE, $d)){
    json_response(["success"=>false, "message"=>"Failed to save"], 500);
}
if($img_to_del !== "") @unlink($img_to_del);

json_response(["success"=>true]);
?>
